<?php
/*--------------------------------------------------------------
   SchemaValidator.php 2021-06-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview;

use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\Schemes;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Schema;
use InvalidArgumentException;

class SchemaValidator
{
    /**
     * @var Schemes
     */
    private $schemes;
    
    
    /**
     * Constructor.
     */
    public function __construct(Schemes $schemes)
    {
        $this->schemes = $schemes;
    }
    
    
    /**
     * Validate data against schema.
     */
    public function validate(string $schemaId, $data): void
    {
        $dataSet = is_array($data) ? json_decode(json_encode($data, JSON_FORCE_OBJECT)) : $data;
        
        /**
         * @var Schema $schema
         */
        foreach ($this->schemes as $schema) {
            if ($schemaId === $schema->id()) {
                $schema->validate($dataSet);
                
                return;
            }
        }
        
        throw new InvalidArgumentException("Schema '$schemaId' not found");
    }
}